# Carpeta de salida
$outDir = ".\png"
if (-not (Test-Path $outDir)) {
    New-Item -ItemType Directory -Force -Path $outDir | Out-Null
}

# Ruta de inkscape
$inkscape = "C:\Program Files\Inkscape\bin\inkscape.exe"

# Obtener lista de SVG
$svgs = Get-ChildItem *.svg

$maxIntentos = 200
$intento = 1

while ($intento -le $maxIntentos) {
    Write-Host "==============================" -ForegroundColor Cyan
    Write-Host " Intento $intento " -ForegroundColor Yellow
    Write-Host "==============================" -ForegroundColor Cyan

    foreach ($svg in $svgs) {
        $outFile = Join-Path $outDir ($svg.BaseName + ".png")
        if (-not (Test-Path $outFile)) {
            Write-Host "Convirtiendo $($svg.Name)..."
            & $inkscape --export-type=png -d 600 --export-filename="$outFile" $svg.FullName
        }
    }

    # Verificar faltantes
    $pngs = Get-ChildItem $outDir -Filter *.png | ForEach-Object { $_.BaseName }
    $faltan = $svgs | Where-Object { $_.BaseName -notin $pngs }

    if ($faltan.Count -eq 0) {
        Write-Host "✅ Todos los $($svgs.Count) archivos convertidos!" -ForegroundColor Green
        break
    } else {
        Write-Host "⚠️ Aún faltan $($faltan.Count) archivos, reintentando..." -ForegroundColor Red
        $intento++
    }
}

if ($intento -gt $maxIntentos) {
    Write-Host "❌ No se pudieron convertir todos tras $maxIntentos intentos." -ForegroundColor DarkRed
}
